#!/bin/bash -l

# 自動ログバックアップをS3へコピー

# エンドポイントDNS名
ENDPOINT_DNS=vpce-xxxx.xxxx.vpce.amazonaws.com

# S3 バケット名
S3BUCKET_NAME=xxxx
# バックアップ先リージョン
BACKUP_REGION=xxxx

# ノードを識別するための名前
NODE_NAME=NODExx
# adminユーザ名
ADMIN_USER=admin
# adminパスワード
ADMIN_PASS=admin

# 自動ログバックアップ作成ディレクトリ
LOCAL_BACKUP_PATH=${GS_HOME}/backup
# 自動ログバックアップのバックアップ名
AUTO_BACKUP_NAME=drautobkup

# 世代番号管理ファイルのパス
DR_BACKUP_GEN_FILE_PATH=${GS_HOME}/dr_backup
DR_BACKUP_GEN_FILE_NAME=dr_backup_gen.txt
DR_BACKUP_GEN_FILE=${DR_BACKUP_GEN_FILE_PATH}/${DR_BACKUP_GEN_FILE_NAME}
# S3上のバックアップのプレフィックスとして使用する名前
DR_BACKUP_PREFIX=dr_backup

# ログ出力先のパス
LOG_PATH=${GS_HOME}/dr_backup
# ログファイル名
LOG_NAME=dr_backup_${NODE_NAME}_auto_backup.log

# ロックファイル
LOCK_PATH=${GS_HOME}/dr_backup
LOCK_FILE_FULLBAKUP_NAME=.lock_fullbk
LOCK_FILE_FULLBAKUP=${LOCK_PATH}/${LOCK_FILE_FULLBAKUP_NAME}
LOCK_FILE_AUTOBAKUP_NAME=.lock_autobk
LOCK_FILE_AUTOBAKUP=${LOCK_PATH}/${LOCK_FILE_AUTOBAKUP_NAME}
PS_NAME_AUTO=auto_bk

ENDPOINT_URL=https://bucket.${ENDPOINT_DNS}


function log () {
  # ログ出力先
  LOG=${LOG_PATH}/${LOG_NAME}
  # ログ出力日時
  time=$(date +"%Y-%m-%d %H:%M:%S")

  # 引数の文字列をログ出力する
  echo -e "${time} $1 $2" >> $LOG
}

function err_exit () {
  # ロックファイル削除
  unlink ${LOCK_FILE_AUTOBAKUP}
  exit 1
}

function check_fullbackup_lock_file () {
  # フルバックアップのロックファイルの有無チェック
  if [ -f ${LOCK_FILE_FULLBAKUP} ]; then
    FULL_PID=$(cat ${LOCK_FILE_FULLBAKUP})
    PS=$(ps aux | grep ${FULL_PID} | grep ${PS_NAME_FULL} | grep -v grep | wc -l)
    if [ ${PS} -eq 0 ]; then
      log INFO "${LOCK_FILE_FULLBAKUP} exists. But process do not exists."
    else
      # ロックファイルが存在し、そのプロセスが残っている場合、バックアップの作成をスキップ
      log ERROR "${LOCK_FILE_FULLBAKUP} exists. skip auto backup."
      err_exit
    fi
  fi
}

function check_lock_file () {
  # ロックファイルの有無チェック
  if [ -f ${LOCK_FILE_AUTOBAKUP} ]; then
    FULL_PID=$(cat ${LOCK_FILE_AUTOBAKUP})
    PS=$(ps aux | grep ${FULL_PID} | grep ${PS_NAME_AUTO} | grep -v grep | wc -l)
    if [ ${PS} -eq 0 ]; then
      log INFO "${LOCK_FILE_AUTOBAKUP} exists. But process do not exists."
    else
      # ロックファイルが存在し、そのプロセスが残っている場合、バックアップの作成をスキップ
      log ERROR "${LOCK_FILE_AUTOBAKUP} exists. skip auto backup."
      err_exit
    fi
  fi
}


# ロックファイルの有無チェック
check_lock_file
# フルバックアップのロックファイルの有無チェック
check_fullbackup_lock_file
# ロックファイル作成
echo $$ > ${LOCK_FILE_AUTOBAKUP}

# 作成するバックアップの世代番号を求める
if [ -f ${DR_BACKUP_GEN_FILE} ]; then
  BACKUP_GEN_NUM=$(cat ${DR_BACKUP_GEN_FILE})
else
  BACKUP_GEN_NUM=0
fi

BACKUP_GEN_PATH_NAME=${DR_BACKUP_PREFIX}${BACKUP_GEN_NUM}

log "INFO" "START copy to ${S3BUCKET_NAME}/${NODE_NAME}/${BACKUP_GEN_PATH_NAME}/autobackup"

# 自動ログバックアップファイルをS3へコピー
aws s3 --region ${BACKUP_REGION} --endpoint-url ${ENDPOINT_URL} sync ${LOCAL_BACKUP_PATH}/${dr_autobkup} s3://${S3BUCKET_NAME}/${NODE_NAME}/${BACKUP_GEN_PATH_NAME}/autobackup/
if [ $? -ne 0 ]; then
  log "ERROR" "failed to copy auto backup"
  err_exit
fi

log "INFO" "END copy to ${S3BUCKET_NAME}/${NODE_NAME}/${BACKUP_GEN_PATH_NAME}/autobackup"

# ロックファイル削除
unlink ${LOCK_FILE_AUTOBAKUP}

exit 0


